<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg="." xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:user="http://mycompany.com/mynamespace">
  <xsl:output method="xml" indent="yes"/>
  <xsl:param name="XOutFname" select="'h:\test2.txt'"/>
  <xsl:param name="OutFileHandle" select="'0'"/>
  <xsl:param name="Filename" select="''"/>
  <!--##############  PARAMETER  ####################-->
  <!--##############  VARIABLES  ####################-->
  <!--##############  BEGIN Namspace cfg   ####################-->
  <cfg:Stylesheet mode="TRANSFORM" version="$Revision: 1.3 $" versionscope="ALL_FILES" backup="true" backupdir="_repair_bu"/>
  <cfg:Description lang="DE">Repair - 2: Suchen von 'siNumber' und 'subNumber' ohne Wert und 0 eintragen. Fehlende Zeitschaltuhr einfügen</cfg:Description>
  <cfg:Description lang="EN">Repair - 2: Look for 'siNumber' and 'subNumber' without value. Set value = 0. Insert TimeControl and the neccessary sub-elements, if missing.</cfg:Description>
  <cfg:Texts>
  </cfg:Texts>
  <!--##############  END Namspace cfg   ####################-->
  <!--##############  MAIN Template for any ROOT ####################-->
  <!--****************  GENERIC PART iterate thru all nodes and copy elements and attribute ***********************-->
  <!-- copies each node implicitly by match 'node()', the attributes need to be copied explicitly by template @*-->
  <!-- we do not copy attributes anymore (exception panelEncoding). Thus we force the creation of new rpsDisplayNames, which have been wrong in some RPS-versions  -->
  <!-- copy all nodes-->
  <xsl:template match="*">
    <xsl:element name="{name()}">
      <xsl:apply-templates select="@* | node()">
    </xsl:apply-templates>
    </xsl:element>
  </xsl:template>
  <!-- explicitly copy attributes -->
  <xsl:template match="@*">
    <xsl:copy/>
  </xsl:template>
  <!-- use root to initialize the XOutput COM-object and write the filename just performed to the output -->
  <xsl:template match="/CONFIG_NETWORK | /CONFIGURATION">
    <xsl:element name="{name()}">
      <xsl:choose>
        <xsl:when test="$OutFileHandle != '0'">
          <xsl:if test="user:XOutSetHandle($OutFileHandle)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="user:XOpen($XOutFname)"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:variable name="Banner">
        <xsl:text>

-> BEGIN: </xsl:text>
        <xsl:value-of select="$Filename"/>
        <xsl:text>
    schema: </xsl:text>
        <xsl:value-of select="//HEADER/dataVersion"/>
        <xsl:if test="//HEADER/convertedFrom != ''">
          <xsl:text>, converted from: </xsl:text>
          <xsl:value-of select="//HEADER/convertedFrom"/>
          <xsl:text>, </xsl:text>
          <xsl:value-of select="//HEADER/converted"/>
        </xsl:if>
      </xsl:variable>
      <xsl:if test="user:XOut(string($Banner))"/>
      <xsl:if test="user:XOut('')"/>
      <xsl:apply-templates select="*"/>
    </xsl:element>
  </xsl:template>
  <!-- scripted output functions using TrafoValidate.XslOutput COM-object -->
  <msxsl:script language="javascript" implements-prefix="user">
   var xout = new ActiveXObject("TrafoValidate.XslOutput");
   function XOut(text)
   {
     xout.WriteLine(text,1); // with endl
     return true;
   }
   function XOpen(path) 
   {
     xout.OpenText(path,0); // CREATE_ALWAYS
     return true;
   }
   function XOutSetHandle(handle) // use already opened file-handle for writing
   {
     xout.SetFileHandle(handle);
     return true;
   }
</msxsl:script>
  <!-- search for siNumber and subNumber, insert 0 if empty value found -->
  <xsl:template match="siNumber | subNumber">
    <xsl:element name="{name()}">
      <xsl:variable name="TextOut">
        <xsl:if test="ancestor::NODE=true()">
          <xsl:value-of select="name(ancestor::NODE)"/>
          <xsl:text>(</xsl:text>
          <xsl:value-of select="ancestor::NODE/netGroup"/>
          <xsl:text>.</xsl:text>
          <xsl:value-of select="ancestor::NODE/netNode"/>
          <xsl:text>) </xsl:text>
        </xsl:if>
        <xsl:text>  (</xsl:text>
        <xsl:value-of select="../../@rpsDisplayName"/>
        <xsl:text>)  //</xsl:text>
        <xsl:value-of select="name(..)"/>
        <xsl:text>/</xsl:text>
        <xsl:value-of select="name(.)"/>
        <xsl:text> has no value, corrected to 0</xsl:text>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test=". = ''">
          <xsl:if test="user:XOut(string($TextOut))"/>
          <xsl:text>0</xsl:text>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="."/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  <!-- Insert TIME_CONTROL to LOGICAL_GROUPING if missing-->
  <xsl:template match="LOGICAL_GROUPING">
    <xsl:element name="{name()}">
      <xsl:for-each select="*">
        <xsl:apply-templates select="."/>
      </xsl:for-each>
      <xsl:if test="TIME_CONTROL = false()">
        <xsl:variable name="TextOut2">
          <xsl:if test="ancestor::NODE=true()">
            <xsl:value-of select="name(ancestor::NODE)"/>
            <xsl:text>(</xsl:text>
            <xsl:value-of select="ancestor::NODE/netGroup"/>
            <xsl:text>.</xsl:text>
            <xsl:value-of select="ancestor::NODE/netNode"/>
            <xsl:text>) </xsl:text>
          </xsl:if>
          <xsl:text>  (</xsl:text>
          <xsl:value-of select="../../@rpsDisplayName"/>
          <xsl:text>)  //</xsl:text>
          <xsl:value-of select="name(..)"/>
          <xsl:text>/TIME_CONTROL was missing. Corrected by tool.</xsl:text>
        </xsl:variable>
        <xsl:element name="TIME_CONTROL">
          <xsl:call-template name="FillTimeControl"/>
        </xsl:element>
        <xsl:if test="user:XOut(string($TextOut2))"/>
      </xsl:if>
    </xsl:element>
  </xsl:template>
  <!-- Fill incomplete TIME_CONTROL -->
  <xsl:template match="TIME_CONTROL">
  <xsl:choose>
    <xsl:when test="* = false()">
      <xsl:variable name="TextOut3">
        <xsl:if test="ancestor::NODE=true()">
          <xsl:value-of select="name(ancestor::NODE)"/>
          <xsl:text>(</xsl:text>
          <xsl:value-of select="ancestor::NODE/netGroup"/>
          <xsl:text>.</xsl:text>
          <xsl:value-of select="ancestor::NODE/netNode"/>
          <xsl:text>) </xsl:text>
        </xsl:if>
        <xsl:text>  (</xsl:text>
        <xsl:value-of select="../../@rpsDisplayName"/>
        <xsl:text>)  //</xsl:text>
        <xsl:value-of select="name(..)"/>
        <xsl:text>/TIME_CONTROL was incomplete. Corrected by tool.</xsl:text>
      </xsl:variable>
        <xsl:element name="TIME_CONTROL">
          <xsl:call-template name="FillTimeControl"/>
        </xsl:element>
        <xsl:if test="user:XOut(string($TextOut3))"/>
    </xsl:when>
    <xsl:otherwise>
        <xsl:element name="TIME_CONTROL">
          <xsl:apply-templates select="*"/>
        </xsl:element>
    </xsl:otherwise>
  </xsl:choose>
  </xsl:template>
  <!--  Create a new minimal TIME_CONTROL which can be edited by RPS -->
  <xsl:template name="FillTimeControl">
    <xsl:element name="CHANNELS">
      <xsl:element name="CHANNEL">
        <xsl:element name="id">20</xsl:element>
        <xsl:element name="target">MP_SI_PANEL.1.0</xsl:element>
        <xsl:element name="ON_ACTION"/>
        <xsl:element name="OFF_ACTION"/>
      </xsl:element>
    </xsl:element>
    <xsl:element name="PROGRAMS"/>
    <xsl:element name="DAYS"/>
  </xsl:template>
</xsl:stylesheet>
